#!/usr/bin/env python
"""Django's command-line utility for administrative tasks."""
import os
import sys
import dotenv
from pathlib import Path


def main():
    """Run administrative tasks."""
    # Get the base directory (where manage.py is located)
    BASE_DIR = Path(__file__).resolve().parent

    # Load environment variables from .env in BASE_DIR
    dotenv.load_dotenv(BASE_DIR / '.env')

    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'warehauser.settings')

    try:
        from django.core.management import execute_from_command_line
    except ImportError as exc:
        raise ImportError(
            "Couldn't import Django. Make sure it's installed and the virtual environment is active."
        ) from exc

    execute_from_command_line(sys.argv)


if __name__ == '__main__':
    main()
